//
//  MainViewController.m
//  iOS SDK Sample
//
//  Created by NEI アプリGr on 2013/06/11.
//  Copyright (c) 2013年 Nippon Primex Inc. All rights reserved.
//

#import "MainViewController.h"

@interface MainViewController ()

@end

@implementation MainViewController

@synthesize sclView = mSclView;

-(void) btnViewSetting : (UIButton *) btnObj
{
    NSString* osversion = [UIDevice currentDevice].systemVersion;
    NSArray* a = [osversion componentsSeparatedByString:@"."];
    
    if([(NSString*)[a objectAtIndex:0] intValue] >= 7)
    {
        btnObj.layer.borderColor = [UIColor blueColor].CGColor;
        btnObj.layer.borderWidth = 1.0f;
        btnObj.layer.cornerRadius = 7.5f;
        
        btnObj.backgroundColor = [UIColor colorWithRed:0.95 green:1.0 blue:1.0 alpha:1.0];
        [btnObj setTintColor:[UIColor blackColor]];
    }
}

-(void) setReturnCode :(int) nmsResult
{
    lblReturnCode.text = [NSString stringWithFormat:@"Return Code: %d", nmsResult];
    
    if(nmsResult != 0)
    {
        lblReturnCode.textColor = [UIColor redColor];
    }
    else
    {
        lblReturnCode.textColor = [UIColor blackColor];
    }
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];

    return self;
}

-(void) appClose
{
    [mObjLib NClosePrinters];
}

-(void) viewDidLayoutSubviews
{
    int nmsWidth    = 0;
    int nmsHeight    = btnBack.frame.origin.y + btnBack.frame.size.height + 200;

    [mSclView setContentSize: CGSizeMake(nmsWidth, nmsHeight)];
    [mSclView flashScrollIndicators];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    txtPrinterName.delegate = self;

    [self btnViewSetting:btnInformation];
    [self btnViewSetting:btnOpenPrt];
    [self btnViewSetting:btnClosePrt];
    [self btnViewSetting:btnAllClosePrt];
    [self btnViewSetting:btnPrint];
    [self btnViewSetting:btnStatus];
    [self btnViewSetting:btnReset];
    [self btnViewSetting:btnBarcode];
    [self btnViewSetting:btnLogCheck];
    [self btnViewSetting:btnVersionCheck];
    [self btnViewSetting:btnReceiptTest];
    [self btnViewSetting:btnTicketTest];
    [self btnViewSetting:btnRepeat];
    [self btnViewSetting:btnBack];
    

    
	// Do any additional setup after loading the view.
    if(mObjLib == nil)
    {
        // comment:NPI NPrinterLib class allocate 
        mObjLib = [[NPrinterLib alloc] init];
        
        // App close setting(Enter backgroud)
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(appClose)
                                                     name:UIApplicationDidEnterBackgroundNotification object:nil];
    }
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

-(BOOL)textFieldShouldReturn:(UITextField*) textField {
    [textField resignFirstResponder];
    return YES;
}

- (IBAction)pushBtnNOpenPrinter:(UIButton *)sender
{
    int nmsRet = 0;
    
    // comment:NPI NOpenPrinter
    nmsRet = [mObjLib NOpenPrinter:[txtPrinterName text] :true];
    
    [self setReturnCode : nmsRet];
}

- (IBAction)pushBtnNClosePrinter:(UIButton *)sender
{
    int nmsRet = 0;
    
    // comment:NPI NClosePrinter
    nmsRet = [mObjLib NClosePrinter: [txtPrinterName text]];
    
    [self setReturnCode : nmsRet];
    
    
    // NPI test
//    if(flgTimer)
//    {
//        [objTimer invalidate];
//        flgTimer = false;
//    }
}

- (IBAction)pushBtnNClosePrinters:(UIButton *)sender
{
    int nmsRet = 0;
    
    // comment:NPI NClosePrinters
    nmsRet = [mObjLib NClosePrinters];
    
    [self setReturnCode : nmsRet];
}

- (IBAction)pushBtnVersionCheck:(UIButton *)sender
{
    // sample app version
    NSString* strAppVersion = [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleShortVersionString"];
    
    NSString* strBuild = [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleVersion"];
    
    
    // comment:NPI SDKVERSION & RELEASEDATE
    NSString* strVersion = [NSString stringWithFormat:@"SDK Version:%s\nDate:%s\nSample app version:%@\nBuild version:%@", SDKVERSION, RELEASEDATE, strAppVersion, strBuild];
    
    
    UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:strVersion
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
    [alert show];
}



-(NSString*) getDateString
{
    NSInteger flags = 0;
    NSCalendar* calendar = [NSCalendar currentCalendar];
    NSDateComponents* comps;
    NSDate* now = [NSDate date];
    
    flags = NSYearCalendarUnit | NSMonthCalendarUnit | NSDayCalendarUnit | NSHourCalendarUnit | NSMinuteCalendarUnit;
    
    comps = [calendar components:flags fromDate:now];
    
    NSInteger year = comps.year;
    NSInteger month = comps.month;
    NSInteger day = comps.day;
    NSInteger hour = comps.hour;
    NSInteger minute = comps.minute;
    
    NSString* strDate = [NSString stringWithFormat:@"%02d/%02d/%04d %02d:%02d",month,day,year,hour,minute];
    
    return strDate;
}

- (IBAction)pushBtnReceiptTest:(UIButton *)sender
{
    int nmsRet = N_SUCCESS;
    int io_jobID = 0;
    
    NSString* strPrtName = [txtPrinterName text];
    
    // comment:NPI NStartDoc
    if((nmsRet = [mObjLib NStartDoc : strPrtName :&io_jobID]) != N_SUCCESS)
    {
        [self setReturnCode : nmsRet];
        return;
    }
    
    // comment:NPI NImagePrintF
    NSString* imgFilePath = [[NSBundle mainBundle] pathForResource:@"npilogo_2inch" ofType:@"bmp"];
    
    if((nmsRet = [mObjLib NImagePrintF : strPrtName : imgFilePath : IMG_RASTER_BLOCK : NULL]) != N_SUCCESS)
    {
        [self setReturnCode : nmsRet];
        return;
    }
    
    // comment:NPI NPrint
    NSMutableString* strPrtData = [NSMutableString string];
    [strPrtData appendString:@"1B6101"];
    [strPrtData appendString:@"\"----- ReceiptSf print -----\"0A1B6100"];
    [strPrtData appendString:@"1B5C1500\"1-5-2, Unoki, Ohtaku, Tokyo\"0A"];
    [strPrtData appendString:@"1B5C1500\"146-8650 Japan\"0A"];
    [strPrtData appendString:@"1B5C1500\"TEL   : 81-3-3750-5817\"0A"];
    [strPrtData appendString:@"1B5C1500\"E-Mail: overseas@primex.co.jp\"0A"];
    [strPrtData appendString:@"1B5C1500\"*****************************\"0A"];
    [strPrtData appendString:@"1B21011B6101\"Thank you for the coming to the store.\"0A"];
    [strPrtData appendString:@"\"I rest and do business this month.\"1B21001B5C00000A"];
    [strPrtData appendString:@"1B61001B5C1500\"*****************************\"0A"];
    [strPrtData appendFormat:@"1B5C1000\"Date : %@\"0A", [self getDateString]];
    [strPrtData appendString:@"0A"];
    [strPrtData appendString:@"1B5C2000\"Coke\"0A"];
    [strPrtData appendString:@"1B5C2000\"    $ 2.00 * 2         $ 4.00\"0A"];
    [strPrtData appendString:@"1B5C2000\"Orange juice\"0A"];
    [strPrtData appendString:@"1B5C2000\"    $ 2.00 * 1         $ 2.00\"0A"];
    [strPrtData appendString:@"1B5C2000\"Beer\"0A"];
    [strPrtData appendString:@"1B5C2000\"    $ 6.00 * 3        $ 18.00\"0A"];
    [strPrtData appendString:@"1B5C1500\"------------------------------\"0A"];
    [strPrtData appendString:@"1B5C1500\"Total   \"1B21201C2104\"  USD 24.00\"1C21001B21000A"];
    [strPrtData appendString:@"1B5C1500\"------------------------------\"0A"];
    [strPrtData appendString:@"1B5C1500\"Deposit \"1B21201C2104\"  USD 30.00\"1C21001B21000A"];
    [strPrtData appendString:@"1B5C1500\"Change  \"1B21201C2104\"  USD  6.00\"1C21001B21000A"];
    
    if((nmsRet = [mObjLib NPrint : strPrtName : strPrtData : (int)[strPrtData length] : &io_jobID]) != N_SUCCESS)
    {
        [self setReturnCode : nmsRet];
        return;
    }
    
    // comment:NPI Barcode setting (It is not required from the next time if you set only for the first time.)
    [mObjLib NBarcode1DSetting : @"Barcode1" : 0 : 3 : 100 : 2 : 0 : 0 : 0 : 0 : @"barcode01.png"];
    
    
    // comment:NPI NBarcode
    NSString* strBcdData = @"012345678905";
    UIImage* objBitmap = [self imageWithColor:[UIColor whiteColor] :432 :150];
    
    nmsRet = [mObjLib NBarcode: strPrtName : @"Barcode1" : objBitmap : 50 : 10 :432 :100 : (char*)[strBcdData UTF8String] : (int)[strBcdData length]];
    
    if(nmsRet != N_SUCCESS)
    {
        [self setReturnCode:nmsRet];
        return;
    }
    
    // comment:NPI NImagePrintF
    NSArray* paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    
    
    NSString* stahomeDir = [paths objectAtIndex:0];
    NSString* i_file = [NSString stringWithFormat:@"%@/npi/image/%@", stahomeDir, @"barcode01.png"];
    
    if((nmsRet = [mObjLib NImagePrintF : strPrtName : i_file : IMG_RASTER_LINE :nil]) != N_SUCCESS)
    {
        [self setReturnCode:nmsRet];
        return;
    }
    
    
    // comment:NPI NPrint
    NSString* strEndPrt = @"1B6101\"http://www.primex.co.jp\"1B61001B4A801B6D1B40";
    if((nmsRet = [mObjLib NPrint : strPrtName : strEndPrt : (int)[strEndPrt length] : NULL]) != N_SUCCESS)
    {
        [self setReturnCode : nmsRet];
        return;
    }
    
    // comment:NPI NEndDoc
    if((nmsRet = [mObjLib NEndDoc : strPrtName]) != N_SUCCESS)
    {
        [self setReturnCode : nmsRet];
        return;
    }
    
    
    [self setReturnCode : nmsRet];
}

- (IBAction)pushBtnTicketTest:(UIButton *)sender
{
    int nmsRet = N_SUCCESS;
    int io_jobID = 0;
    
    NSString* strPrtName = [txtPrinterName text];
    
    // comment:NPI NStartDoc
    if((nmsRet = [mObjLib NStartDoc : strPrtName :&io_jobID]) != N_SUCCESS)
    {
        [self setReturnCode : nmsRet];
        return;
    }
    
    // comment:NPI NPrint (page mode start)
    NSMutableString* strPrtData = [NSMutableString string];
    [strPrtData appendString:@"1B40"];
    [strPrtData appendString:@"1B5401"];                // page mode rotate
    [strPrtData appendString:@"1B6C4C"];                // page mode length
    [strPrtData appendString:@"1B5705004030"];          // page mode size
    [strPrtData appendString:@"1B4C11300005000001"];

    if((nmsRet = [mObjLib NPrint : strPrtName : strPrtData : (int)[strPrtData length] : &io_jobID]) != N_SUCCESS)
    {
        [self setReturnCode : nmsRet];
        return;
    }
    
    // comment:NPI NImagePrintF
    NSString* imgFilePath = [[NSBundle mainBundle] pathForResource:@"npilogo_2inch" ofType:@"bmp"];
    
    if((nmsRet = [mObjLib NImagePrintF : strPrtName : imgFilePath : IMG_RASTER_LINE : NULL]) != N_SUCCESS)
    {
        [self setReturnCode : nmsRet];
        return;
    }
    
    
    // comment:NPI NPrint
    strPrtData = [NSMutableString string];
    [strPrtData appendString:@"1B4C10"];
    [strPrtData appendString:@"1B4C11050060000001"];
    [strPrtData appendFormat:@"1B6100\"Date of issuance    : %@\"0A",[self getDateString]];
    [strPrtData appendString:@"1B6100\"Coupon type         : Ticket print\"0A"];
    
    [strPrtData appendString:@"1B5C5000"];
    [strPrtData appendString:@"1B2138"];
    [strPrtData appendString:@"1B2D02"];
    [strPrtData appendString:@"\"All item 20% OFF!\"0A"];
    [strPrtData appendString:@"1B2100"];
    
    if((nmsRet = [mObjLib NPrint : strPrtName : strPrtData : (int)[strPrtData length] : &io_jobID]) != N_SUCCESS)
    {
        [self setReturnCode : nmsRet];
        return;
    }
    
    
    // comment:NPI Barcode setting (It is not required from the next time if you set only for the first time.)
    [mObjLib NBarcode1DSetting : @"Barcode1" : 0 : 3 : 70 : 2 : 0 : 0 : 0 : 0 : @"barcode01.png"];
    
    
    // comment:NPI NBarcode
    NSString* strBcdData = @"012345678905";
    UIImage* objBitmap = [self imageWithColor:[UIColor whiteColor] :500 :110];
    
    nmsRet = [mObjLib NBarcode: strPrtName : @"Barcode1" : objBitmap : 120 : 10 : 500 : 100 : (char*)[strBcdData UTF8String] : (int)[strBcdData length]];
    
    if(nmsRet != N_SUCCESS)
    {
        [self setReturnCode:nmsRet];
        return;
    }
    
    // comment:NPI NImagePrintF
    NSArray* paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    
    
    NSString* stahomeDir = [paths objectAtIndex:0];
    NSString* i_file = [NSString stringWithFormat:@"%@/npi/image/%@", stahomeDir, @"barcode01.png"];
    
    if((nmsRet = [mObjLib NImagePrintF : strPrtName : i_file : IMG_BITIMG :nil]) != N_SUCCESS)
    {
        [self setReturnCode:nmsRet];
        return;
    }
      
    // comment:NPI NPrint
    strPrtData = [NSMutableString string];
    [strPrtData appendString:@"1B5C0000"];
    [strPrtData appendString:@"\"http://www.primex.co.jp/npiweb/index_e.jsp\"0A"];
    [strPrtData appendString:@"1B4C10"];
    [strPrtData appendString:@"1B0C00"];
    [strPrtData appendString:@"1B4A7F"];        // Feed
    [strPrtData appendString:@"1B6D"];
    [strPrtData appendString:@"1B40"];
    [strPrtData appendString:@"18"];            // page mode buffer clear
    
    if((nmsRet = [mObjLib NPrint : strPrtName : strPrtData : (int)[strPrtData length] : &io_jobID]) != N_SUCCESS)
    {
        [self setReturnCode : nmsRet];
        return;
    }
   
    
    // comment:NPI NEndDoc
    if((nmsRet = [mObjLib NEndDoc : strPrtName]) != N_SUCCESS)
    {
        [self setReturnCode : nmsRet];
        return;
    }
    
    [self setReturnCode : nmsRet];
}

- (IBAction)pushBtnBack:(UIButton *)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

-(UIImage*) imageWithColor : (UIColor*) color : (int) nWidth : (int) nHeight
{
    CGRect rect = CGRectMake(0, 0, nWidth, nHeight);
    UIGraphicsBeginImageContext(rect.size);
    CGContextRef context = UIGraphicsGetCurrentContext();
    
    CGContextSetFillColorWithColor(context, [color CGColor]);
    CGContextFillRect(context, rect);
    
    UIImage* image = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return image;
}

-(void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender{
    
    [mSclView setContentOffset:CGPointMake(0.0f, 0.0f)];
    
    // comment:NPI How to pass a 'NPrinterLib' class to the next screen.
    
    if([segue.identifier isEqualToString:@"form01Segue"])
    {
        SubForm01ViewController* sub01 = segue.destinationViewController;
        sub01.objLib = mObjLib;
        sub01.strPrtName = [txtPrinterName text];
    }
    
    if([segue.identifier isEqualToString:@"form02Segue"])
    {
        SubForm02ViewController* sub02 = segue.destinationViewController;
        sub02.objLib = mObjLib;
        sub02.strPrtName = [txtPrinterName text];
    }
    
    if([segue.identifier isEqualToString:@"form03Segue"])
    {
        SubForm03ViewController* sub03 = segue.destinationViewController;
        sub03.objLib = mObjLib;
        sub03.strPrtName = [txtPrinterName text];
    }
    
    if([segue.identifier isEqualToString:@"form04Segue"])
    {
        SubForm04ViewController* sub04 = segue.destinationViewController;
        sub04.objLib = mObjLib;
        sub04.strPrtName = [txtPrinterName text];
    }
    
    if([segue.identifier isEqualToString:@"form05Segue"])
    {
        SubForm05ViewController* sub05 = segue.destinationViewController;
        sub05.objLib = mObjLib;
        sub05.strPrtName = [txtPrinterName text];
    }
    
    if([segue.identifier isEqualToString:@"form06Segue"])
    {
        SubForm06ViewController* sub06 = segue.destinationViewController;
        sub06.objLib = mObjLib;
        sub06.strPrtName = [txtPrinterName text];
    }
    
    if([segue.identifier isEqualToString:@"form07Segue"])
    {
        SubForm07ViewController* sub07 = segue.destinationViewController;
        sub07.objLib = mObjLib;
        sub07.strPrtName = [txtPrinterName text];
    }
}



- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    // キーボード表示・非表示時のイベント登録
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWasShown:)
                                                 name:UIKeyboardDidShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWasHidden:)
                                                 name:UIKeyboardDidHideNotification object:nil];
}

- (void)viewWillDisappear:(BOOL)animated {
    // キーボード表示・非表示時のイベント削除
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)keyboardWasShown:(NSNotification *)notification {
    NSDictionary *info = [notification userInfo];
    CGSize kbSize = [[info objectForKey:UIKeyboardFrameBeginUserInfoKey] CGRectValue].size;
    
    UIEdgeInsets contentInsets = UIEdgeInsetsMake(0.0, 0.0, kbSize.height, 0.0);
    
    self.sclView.contentInset = contentInsets;
    self.sclView.scrollIndicatorInsets = contentInsets;
    
    CGRect aRect = self.view.frame;
    aRect.size.height -= kbSize.height;
    if (_activeField != nil) {
        CGPoint scrollPoint = CGPointMake(0.0, _activeField.frame.origin.y - 30);
        [self.sclView setContentOffset:scrollPoint animated:YES];
    }
}

- (void)keyboardWasHidden:(NSNotification *)notification {
    UIEdgeInsets contentInsets = UIEdgeInsetsZero;
    self.sclView.contentInset = contentInsets;
    self.sclView.scrollIndicatorInsets = contentInsets;
}

- (void)textFieldDidBeginEditing:(UITextField *)textField {
    _activeField = textField;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    _activeField = nil;
}

@end
